#!/usr/local/bin/python3
# coding: utf8

import requests
import json
from prettytable import PrettyTable
import const


def get_watch_advisories():
    """
    Get the 25 most recent security watch advisories:

    By sending an HTTP request, we will be able to get advisories in the JSON format
    which can then be manipulated to get any specific information.

    author: ebaudin
    """

    print("--- Get Watch Advisories ---")
    
    # API key could be obtained as described in the documentation : https://leportail.xmco.fr/doc/api
    # We recommend using a dedicated service account when used in script
    # Edit const to use your own API key
    authentication_headers = dict(Authorization=f"Bearer {const.API_KEY}")
    
    params = {"sort": "-_created"}
    r = requests.get(const.API_ADVISORY_ENDPOINT, params=params, headers=authentication_headers)
                     
    advisories_json = json.loads(r.text)['_items']
    table = PrettyTable(['Type', 'Severity', 'Title'])
    table.align = 'l'

    for advisory in advisories_json:
        table.add_row([advisory["advisory_type"], advisory["severity"].upper(), advisory["content_fr"]["title"]])

    print(table)


if __name__ == '__main__':
    get_watch_advisories()
