#!/usr/local/bin/python3
# coding: utf8

import requests
import json
import const


def update_action_ticket(id_ticket):
    """
    Update an action ticket:

    In this example, we will update the severity of the following action ticket:
    https://leportail.xmco.fr/action_plan/5eeb7a534a359b000cbd5136.

    To do this, we need to get the `_etag` parameter that we will send along with
    the data to be updated in the ticket in a PATCH request.

    author: ebaudin
    """

    print("--- Update tickets ---")

    # API key could be obtained as described in the documentation : https://leportail.xmco.fr/doc/api
    # We recommend using a dedicated service account when used in script
    # Edit const to use your own API key
    authentication_headers = dict(Authorization=f"Bearer {const.API_KEY}")

    print("[+] Preview of the ticket:")
    url = "%s/%s" % (const.API_ACTION_PLAN_ENDPOINT, id_ticket)

    r = requests.get(url, headers=authentication_headers)
    ticket = json.loads(r.text)
    etag = ticket["_etag"]

    print("%s - %s" % (ticket["severity"], ticket["title"]))

    # For this example we will update the severity of the ticket
    if ticket["severity"] == "low":
        severity = "medium"
    else:
        severity = "low"    

    print("[+] Update the severity of the ticket")
    r = requests.patch(url, headers={"If-Match": etag}, json={"severity": severity},
                       headers=authentication_headers)

    print("[+] Preview of the ticket updated:")
    r = requests.get(url, headers=authentication_headers)
    ticket = json.loads(r.text)

    print("%s - %s" % (ticket["severity"], ticket["title"]))


if __name__ == '__main__':
    # The following value is an XMCO ticket `_id` for presentation purposes,
    # Change this value with one of your tickets `_id`

    xmco_ticket = "5eeb7a534a359b000cbd5136"
    update_action_ticket(xmco_ticket)
