#!/usr/local/bin/python3
# coding: utf8

import requests
import json
import const


def update_status_serenety_ticket(id_ticket):
    """
    Update the status of an action ticket:

    In this example, we will update the status of the following action ticket:
    https://leportail.xmco.fr/action_plan/635beca094b101000d1660de.

    To do this, we need to get the `_etag` parameter that we will send along with
    the data to be updated in the ticket in a PATCH request.

    author: wbillaud
    """

    print("--- Update tickets ---")

    # API key could be obtained as described in the documentation : https://leportail.xmco.fr/doc/api
    # We recommend using a dedicated service account when used in script
    # Edit const to use your own API key
    authentication_headers = dict(Authorization=f"Bearer {const.API_KEY}")

    print("[+] Preview of the ticket:")
    url = "%s/%s" % (const.API_ACTION_PLAN_ENDPOINT, id_ticket)

    r = requests.get(url, headers=authentication_headers)
    ticket = json.loads(r.text)
    etag = ticket["_etag"]

    print("%s - %s" % (ticket["status"], ticket["title"]))

    # For this example we will update the severity of the ticket
    if ticket["status"] == "in_progress":
        severity = "fixed"
    else:
        severity = "in_progress"    

    print("[+] Update the status of the ticket")
    r = requests.patch(url, headers={**{"If-Match": etag}, **authentication_headers}, json={"status": severity})

    print("[+] Preview of the ticket updated:")
    r = requests.get(url, headers=authentication_headers)
    ticket = json.loads(r.text)

    print("%s - %s" % (ticket["status"], ticket["title"]))


if __name__ == '__main__':
    # The following value is an XMCO ticket `_id` for presentation purposes,
    # Change this value with one of your tickets `_id`

    xmco_ticket = "635beca094b101000d1660de"
    update_status_serenety_ticket(xmco_ticket)
