#!/usr/local/bin/python3
# coding: utf8

import requests
import json
from prettytable import PrettyTable
import const


def get_watch_scopes():
    """
    Get the watch scopes:

    By sending an HTTP request to the `/scope` endpoint, we can get the scope_id of scopes

    author: ebaudin
    """

    print("--- Get Watch Scopes ---")
    
    # API key could be obtained as described in the documentation : https://leportail.xmco.fr/doc/api
    # We recommend using a dedicated service account when used in script
    # Edit const to use your own API key
    authentication_headers = dict(Authorization=f"Bearer {const.API_KEY}")

    params = {
        "type": "watch",
        "sort": "name"
    }

    r = requests.get(const.API_SCOPE_ENDPOINT, params=params, headers=authentication_headers)
                     
    scopes_json = json.loads(r.text)['_items']
    table = PrettyTable(['Scope name', 'Id'])
    table.align = 'l'

    for scope in scopes_json:
        table.add_row([scope["name"], scope["_id"]])

    print(table)


if __name__ == '__main__':
    get_watch_scopes()
