#!/usr/local/bin/python3
# coding: utf8

import requests
import json
from prettytable import PrettyTable
import const


def get_serenety_assets():
    """
    Get Serenety assets:

    In this example, we will print the properties of the asset www.xmco.fr.

    author: ebaudin
    """

    print("--- Get Serenety Assets ---")

    # API key could be obtained as described in the documentation : https://leportail.xmco.fr/doc/api
    # We recommend using a dedicated service account when used in script
    # Edit const to use your own API key
    authentication_headers = dict(Authorization=f"Bearer {const.API_KEY}")

    params = {
        "where": json.dumps({
            "type": "hostname",
            "value": "www.xmco.fr"
        })
    }
    r = requests.get(const.API_SERENETY_ASSETS_ENDPOINT, params=params, headers=authentication_headers)


    table = PrettyTable(['Name', 'SSLLABS Mark'])
    table.align = 'l'
    data = json.loads(r.text)["_items"]
    if len(data) == 0:
        print(f"Asset not found : {params['where']}")
        return
    
    print("\n[+] Preview of SSLLABS grades:")

    for hostname in data:
        if "ssllabs" in hostname["properties"]:
            table.add_row([hostname["value"], hostname["properties"]["ssllabs"][0]["mark"]])
        else:
            table.add_row([hostname["value"], "N/A"])
    
    print(table)

    print("\n[+] Preview of certificate expiration dates:")

    table = PrettyTable(["Name", "Certificate expiration date"])
    table.align = 'l'

    for hostname in data:
        if "ssl_cert" in hostname["properties"]:
            table.add_row(
                [hostname["value"], hostname["properties"]["ssl_cert"][0]["valid_to"]]
            )
        else:
            table.add_row([hostname["value"], "N/A"])
    
    print(table)
    
    
if __name__ == '__main__':
    get_serenety_assets()
