#!/usr/local/bin/python3
# coding: utf8

import requests
import json
from prettytable import PrettyTable
import const


def get_tickets_company():
    """
    Get the lastest 25 company tickets:

    We will first ask the server for our `company_id` and then for our action plan
    at `/action_plan/list`.

    author: ebaudin
    """

    print("--- Get All Tickets Of The Company ---")
    # API key could be obtained as described in the documentation : https://leportail.xmco.fr/doc/api
    # We recommend using a dedicated service account when used in script
    # Edit const to use your own API key
    authentication_headers = dict(Authorization=f"Bearer {const.API_KEY}")
    
    r = requests.get(const.API_CURRENT_USER_ENDPOINT, headers=authentication_headers)
    company_id = json.loads(r.text)["user"]["company"]
    
    params = {
        "company_id": company_id,
        "sort": "_created",
        "order": "DESC"
    }
    r = requests.get(const.API_ACTION_PLAN_LIST_ENDPOINT, params=params, headers=authentication_headers)
    
    tickets_json = json.loads(r.text)['_items']
    table = PrettyTable(['Status', 'Severity', 'Title'])
    table.align = 'l'

    for ticket in tickets_json:
        table.add_row([ticket["status"], ticket["severity"].upper(), ticket["title"]])

    print(table)
    

if __name__ == '__main__':
    get_tickets_company()
