#!/usr/local/bin/python3
# coding: utf8

import requests
import json
from prettytable import PrettyTable
import const 


def get_tickets_by_module():
    """
    Get the lastest 25 tickets of a specific module (watch in this example):

    We will first ask the server for our `company_id` and then for the tracker id
    and finally our action plan at `/action_plan/list`.

    author: ebaudin
    """

    print("--- Get Tickets By Module ---")

    # API key could be obtained as described in the documentation : https://leportail.xmco.fr/doc/api
    # We recommend using a dedicated service account when used in script
    # Edit const to use your own API key
    authentication_headers = dict(Authorization=f"Bearer {const.API_KEY}")
    
    r = requests.get(const.API_CURRENT_USER_ENDPOINT, headers=authentication_headers)
    company_id = json.loads(r.text)["user"]["company"]
    
    json_data = {"module": "watch"}
    r = requests.post(const.API_TRACKER_BY_COMPANY_ENDPOINT, json=json_data, headers=authentication_headers)
    
    tracker_id = [json.loads(r.text)['_items'][0]["_id"]]

    params = {
        "company_id": company_id,
        "sort": "_created",
        "order": "DESC",
        "queryExtras": json.dumps({
            "tracker": {"$in": tracker_id}
        })
    }
    r = requests.get(const.API_ACTION_PLAN_LIST_ENDPOINT, params=params, headers=authentication_headers)
    
    tickets_json = json.loads(r.text)['_items']
    table = PrettyTable(['Status', 'Severity', 'Title'])
    table.align = 'l'

    for ticket in tickets_json:
        table.add_row([ticket["status"], ticket["severity"].upper(), ticket["title"]])

    print(table)
    

if __name__ == '__main__':
    get_tickets_by_module()
