#!/usr/local/bin/python3
# coding: utf8

import requests
import json
from prettytable import PrettyTable
import const


def get_ticket_by_scope(scope_id):
    """
    Get the 25 most recent security watch advisories associated to a specific scope:

    To do that, we first need to list the CPE associated with our scope in what we call a
    fake asset. This asset contains all CPE used in the scope, meaning all the technologies followed.

    Then, we will filter the XMCO database of advisories with the CPE names extracted.

    author: ebaudin
    """

    print("--- Get Tickets By Scope ---")

    # API key could be obtained as described in the documentation : https://leportail.xmco.fr/doc/api
    # We recommend using a dedicated service account when used in script
    # Edit const to use your own API key
    authentication_headers = dict(Authorization=f"Bearer {const.API_KEY}")
    params = {"scope_id": scope_id}
    r = requests.get(const.API_ACTION_PLAN_LIST_ENDPOINT, params=params, headers=authentication_headers)
    
    tickets_json = json.loads(r.text)['_items']

    print("\n[+] Preview of tickets associated with the scope %s:" % scope_id)
    table = PrettyTable(['Severity', 'Subcategory', 'Title'])
    table.align = 'l'

    for ticket in tickets_json:
        table.add_row([ticket["severity"].upper(), ticket["custom_fields"]["subcategory"], ticket["title"]])

    print(table)


if __name__ == '__main__':
    # The following value is an XMCO scope for presentation purposes,
    # Change this value with one of your scopes `_id`.

    xmco_scope = "5d4997e8e711ec000a5c49d5"
    get_ticket_by_scope(xmco_scope)
