# leportail-api-demo

## Description

This project aims at providing simple examples of scripts to interact with the CERT-XMCO portal API.

11 scripts written in `Python` are thus made available covering a large range of the features of the API in order to :
* learn how to authenticate yourself ;
* get Watch information (scopes, all advisories or advisories filtered)
* get Serenety information (scopes, assets and their properties)
* get action tickets information (from the whole company, assigned to me or associated to a specific module or specific scope)
* update action tickets.

## Installation

To use the scripts, you need a `Python 3` environment. Once the project is fetched, it will be necessary to use the following command to install the few dependencies:

`pip install -r requirements.txt`

Each script can then be executed separately.

**Important note :** For presentation purposes, several scripts have a fixed value for a scope or ticket `_id`. Please bear in mind to modify these on your first launch of the script.

## Authentication

* API key could be obtained as described in the documentation : https://leportail.xmco.fr/doc/api ;
* Your API key must be added in the file `const.py` ( variable `API_KEY`) ;
* We recommend using a dedicated service account when used in production mode ;

## List of scripts available

11 scripts are made available :
* `1.get_watch_advisories.py`: to learn how to get all recent watch advisories;
* `2.get_watch_scope.py`: to learn how to get all Watch scopes created information;
* `3.get_watch_advisories_by_scope.py`: to learn how to get all Watch advisories filtered to one or multiple scopes;
* `4.get_serenety_scope.py`: to learn how to get all Serenety scopes created;
* `5.get_serenety_assets.py`: to learn how to get all Serenety assets created including their properties (SSLLABS, open ports, etc.);
* `6.get_tickets_company.py`: to learn how to get all action tickets created;
* `7.get_tickets_assigned_to_me.py`: to learn how to get all action tickets assigned to me;
* `8.get_tickets_by_module.py`: to learn how to get all action tickets filtered by modules;
* `9.get_ticket_by_scope.py`: to learn how to get all action tickets filtered by scopes;
* `10.update_ticket.py`: to learn how to update an action ticket.
* `11.update_status_serenety_ticket.py`: to learn how to mark a serenety ticket as resolved.
* `12.send_ticket_to_the_hive,py`: lean how to forward ticket created during the last hour in the hive (AUTH_HIVE_TOKEN and THE_HIVE_CREATE_ENDPOINT mentioned in const.py needs to be updated). 